# Change values of matrix1, array and array1 as per your module names

matrix = ["Acc","o","d","a"]
array = ["accurate","approx_o4","approx_d4","approx_a4"]
for i1 in range(0,4):
	for i2 in range (0,4):
		for i3 in range(0,4):
			for i4 in range(0,4):
				s=matrix[i1]+matrix[i2]+matrix[i3]+matrix[i4]
				with open("mult_mod_8_%s_acc.vhd" % s, "w") as fh1:
					fh1.write("library IEEE;\n")
					fh1.write("use IEEE.STD_LOGIC_1164.ALL;\n")
					fh1.write("use IEEE.NUMERIC_STD.ALL;\n")
					fh1.write("use IEEE.STD_LOGIC_UNSIGNED.ALL;\n")
					fh1.write("library UNISIM;\n")
					fh1.write("use UNISIM.VComponents.all;\n")
					fh1.write("\n")
					fh1.write("entity mult_mod_8_" + s +"_acc is\n")
					fh1.write("Port (\n")
					fh1.write("A : in STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("B : in STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("PROD : out STD_LOGIC_VECTOR (15 downto 0));\n")
					fh1.write("end mult_mod_8_" + s + "_acc;\n")
					fh1.write("\n")
					fh1.write("architecture Behavioral of mult_mod_8_" + s + "_acc is\n")
					fh1.write("\n")
					fh1.write("component mult_accurate is\n")
					fh1.write("		Port ( a : in  STD_LOGIC_VECTOR (3 downto 0);\n")
					fh1.write("			   b : in  STD_LOGIC_VECTOR (3 downto 0);\n")
					fh1.write("			   prod : out  STD_LOGIC_VECTOR (7 downto 0));\n")
					fh1.write("end component;\n")
					fh1.write("\n")
					fh1.write("component mult_approx_o4 is\n")
					fh1.write("		Port ( a : in  STD_LOGIC_VECTOR (3 downto 0);\n")
					fh1.write("			   b : in  STD_LOGIC_VECTOR (3 downto 0);\n")
					fh1.write("			   prod : out  STD_LOGIC_VECTOR (7 downto 0));\n")
					fh1.write("end component;\n")
					fh1.write("\n")
					fh1.write("component mult_approx_d4 is\n")
					fh1.write("		Port ( a : in  STD_LOGIC_VECTOR (3 downto 0);\n")
					fh1.write("			   b : in  STD_LOGIC_VECTOR (3 downto 0);\n")
					fh1.write("			   prod : out  STD_LOGIC_VECTOR (7 downto 0));\n")
					fh1.write("end component;\n")
					fh1.write("\n")
					fh1.write("component mult_approx_a4 is\n")
					fh1.write("		Port ( a : in  STD_LOGIC_VECTOR (3 downto 0);\n")
					fh1.write("			   b : in  STD_LOGIC_VECTOR (3 downto 0);\n")
					fh1.write("			   prod : out  STD_LOGIC_VECTOR (7 downto 0));\n")
					fh1.write("end component;\n")
					fh1.write("component adder is\n")
					fh1.write("		Port ( prod1 : in  STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("			   prod2 : in  STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("			   prod3 : in  STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("			   prod4 : in  STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("			   PROD : out  STD_LOGIC_VECTOR (15 downto 0));\n")
					fh1.write("end component;\n")
					fh1.write("\n")
					fh1.write("signal prod1 : STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("signal prod2 : STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("signal prod3 : STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("signal prod4 : STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("signal gen : STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("signal prop : STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("signal carries : STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("signal output : STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("signal input_carry : STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("signal chain : STD_LOGIC_VECTOR (7 downto 0);\n")
					fh1.write("signal temp : STD_LOGIC;\n")
					fh1.write("\n")
					fh1.write("begin\n")
					#	Instantiate the four N/2 multiplier modules
					fh1.write("inst1_mult: mult_" + array[i1] + " port map(\n")
					fh1.write("a => A(3 downto 0),\n")
					fh1.write("b => B(3 downto 0),\n")
					fh1.write("prod => prod1\n")
					fh1.write(");\n")
					fh1.write("\n")
					fh1.write("inst2_mult: mult_" + array[i2] + " port map(\n")
					fh1.write("a => A(7 downto 4),\n")
					fh1.write("b => B(3 downto 0),\n")
					fh1.write("prod => prod2\n")
					fh1.write(");\n")
					fh1.write("\n")
					fh1.write("inst3_mult: mult_" + array[i3] + " port map(\n")
					fh1.write("a => A(3 downto 0),\n")
					fh1.write("b => B(7 downto 4),\n")
					fh1.write("prod => prod3\n")
					fh1.write(");\n")
					fh1.write("\n")
					fh1.write("inst4_mult: mult_" + array[i4] + " port map(\n")
					fh1.write("a => A(7 downto 4),\n")
					fh1.write("b => B(7 downto 4),\n")
					fh1.write("prod => prod4\n")
					fh1.write(");\n")
					fh1.write("\n")
					#	Instantiate the adder (accurate / any other approximate adder)
					fh1.write("inst_add: adder port map(\n")
					fh1.write("prod1 => prod1,\n")
					fh1.write("prod2 => prod2,\n")
					fh1.write("prod3 => prod3,\n")
					fh1.write("prod4 => prod4,\n")
					fh1.write("PROD => PROD\n")
					fh1.write(");\n")
					fh1.write("\n")
					fh1.write("\n")
					fh1.write("end Behavioral;")

					#	Following is  code for testbench	
				with open("tb_mult_%s_acc.vhd" % s, "w") as fh2: 	
					fh2.write("library IEEE;\n")
					fh2.write("use IEEE.STD_LOGIC_1164.ALL;\n")
					fh2.write("use IEEE.NUMERIC_STD.ALL;\n")
					fh2.write("library UNISIM;\n")
					fh2.write("use UNISIM.VComponents.all;\n")
					fh2.write("use std.textio.all;\n")
					fh2.write("use work.all;\n")
					fh2.write("use work.str_to_stdvec_helpers.all;\n")
					fh2.write("\n")
					fh2.write("entity tb_mult_" + s + "_acc is\n")
					fh2.write("end tb_mult_" + s + "_acc;\n")
					fh2.write("\n")
					fh2.write("architecture Behavioral of tb_mult_" + s + "_acc is\n")
					fh2.write("component mult_mod_8_" + s +"_acc is\n")
					fh2.write("		Port ( A : in  STD_LOGIC_VECTOR (7 downto 0);\n")
					fh2.write("			   B : in  STD_LOGIC_VECTOR (7 downto 0);\n")
					fh2.write("			   PROD : out  STD_LOGIC_VECTOR (15 downto 0));\n")
					fh2.write("end component;\n")
					fh2.write("signal a_sig, b_sig: STD_LOGIC_VECTOR (7 downto 0) :=(others => '0');\n")
					fh2.write("signal prod_sig: STD_LOGIC_VECTOR (15 downto 0);\n")
					fh2.write("\n")
					fh2.write("begin\n")
					fh2.write("inst1_mult: mult_mod_8_" + s +"_acc port map(\n")
					fh2.write("A => a_sig,\n")
					fh2.write("B => b_sig,\n")
					fh2.write("PROD => prod_sig\n")
					fh2.write(");\n")
					fh2.write("stim: process\n")
					fh2.write("\n")
					fh2.write("		file output_file : text;\n")
					fh2.write("		variable str_stimulus_out : string(16 downto 1);\n")
					fh2.write("		variable file_line_out : line;\n")
					fh2.write("begin\n")
					fh2.write("		file_open(output_file, \"mult_8x8_" + s + "_acc.txt\", WRITE_MODE);\n")
					fh2.write("		for j in 0 to 255 loop\n")
					fh2.write("			for i in 0 to 255 loop\n")
					fh2.write("				a_sig <= std_logic_vector(to_unsigned(i, 8));\n")
					fh2.write("				b_sig <= std_logic_vector(to_unsigned(j, 8));\n")
					fh2.write("				wait for 1 ns;\n")
					fh2.write("				str_stimulus_out := stdvec_to_str(prod_sig);\n")
					fh2.write("				write(file_line_out, str_stimulus_out);\n")
					fh2.write("				writeline(output_file, file_line_out);\n")
					fh2.write("			end loop;\n")
					fh2.write("		end loop;\n")
					fh2.write("		wait;\n")
					fh2.write("		file_close(output_file);\n")
					fh2.write("end process;\n")
					fh2.write("\n")
					fh2.write("end Behavioral;\n")







